<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubFilter extends Model 
{

    protected $table = 'sub_filters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'filter_id', 'recurring_sub_filter_id');

    public function filter()
    {
        return $this->belongsTo('App\Models\Filter');
    }

    public function recurringSubFilter()
    {
        return $this->belongsTo('App\Models\SubFilterRecurring');
    }

}